'************************************************
' File:    ReadTxt.vbs (WSH sample in VBScript) 
' Author:  (c) G. Born
'
' Reading the content of a text file and
' displaying it in a dialog box. The script
' uses defaults for "iomode."
'************************************************
Option Explicit

Dim Text, Title
Dim fso, objArgs                ' Object variables
Dim txtStream                   ' Text stream
Dim file                        ' Filename

file = "D:\Documenti\Raffaele.txt"        ' File da leggere

' Try to get a filename from the Arguments collection.
Set objArgs = WScript.Arguments ' Create object.
If objArgs.Count > 0 Then       ' Argument found.
    file = objArgs(0)           ' Set filename to first argument.
End If

Text = "Content of " & file & vbCrLf & vbCrLf
Title = "Raffaele Chiatto Produced"

' Create FileSystemObject object to access the file system.
Set fso = CreateObject("Scripting.FileSystemObject")
' Check whether file exists.
If fso.FileExists(file) Then
    Set txtStream = fso.OpenTextFile(file) ' Open text file.
    Do While Not (txtStream.atEndOfStream)
        Text = Text & txtStream.ReadLine & vbCrLf
    Loop
Else                  ' Terminate.
    MsgBox "File '" & file & "' not found", _
           vbOKOnly + vbCritical, Title 
    WScript.Quit 1    ' Terminate with error code.
End If

If MsgBox("Show results in dialog box?", vbYesNo, Title) _
    = vbYes Then    ' Show result in message box.
    MsgBox Text, vbOKOnly + vbInformation, Title
Else                ' Use browser window for results.
    MakeHTMLCode Text, 0      ' Convert text to HTML (only < and >).
    ShowWindow Text, Title    ' Show result in HTML window.
End If 

Sub ShowWindow(txt, title)
    Dim oIE, doc1
    ' Create Internet Explorer Application object.
    Set oIE = WScript.CreateObject("InternetExplorer.Application")
    oIE.Navigate "about:blank"  ' Empty HTML document 
    oIE.Visible = 1             ' Internet Explorer is visible.
    oIE.ToolBar = 0
    oIE.StatusBar = 0
    'oIE.Width = 600
    oIE.Height = 500 

    Do While (oIE.Busy): Loop   ' Important: Wait until Internet 
                                ' Explorer is ready.
 
    Set doc1 = oIE.Document     ' Get Document object.
    doc1.open                   ' Open document.
    ' Write script to the Document object.
    doc1.writeln "<html><head><title>" & Title & "</title></head>"
    doc1.writeln "<body bgcolor='#FAF0F0'><pre>"
    doc1.writeln txt            ' Text output
    doc1.writeln "</pre></body></html>"
    doc1.close                  ' Close document for write access.
End Sub

Sub MakeHTMLCode(txt, flag)
    ' Convert text file to HTML structure.
    ' Flag controls which elements are converted.
    ' Use the following values:
    ' 0: Convert all < and > characters to &lt; and &gt;.
    ' 1: Like flag = 0, but also sets vbCrLf to <br> tag 
    '    (forces line wrap).
    ' 2: Like flag = 1, but also sets blanks to &nbsp;.
    ' ### Be careful of the order of pattern replacement. ###
    Dim oReg
    Set oReg = New RegExp        ' Create regular expression.
    oReg.Global = True           ' All matches
    oReg.IgnoreCase = True       ' Make case insensitive.

    ' Replace all < with &lt;.
    oReg.Pattern = "<"           ' Set pattern.
    txt = oReg.Replace(txt, "&lt;")

    ' Replace all ">" with "&gt;"
    oReg.Pattern = ">"           ' Set pattern.
    txt = oReg.Replace(txt, "&gt;")

    If flag > 0 Then             ' Replace vbCrLf?
        ' Now we're ready to replace all vbCrLf with <br>.
        oReg.Pattern = vbCrLf       ' Set pattern.
        oReg.Global = True          ' All matches
        txt = oReg.Replace(txt, "<br>")
    End If

    If flag > 1 Then             ' Replace blanks?
        ' Now we're ready to replace all blanks with &nbsp;.
        oReg.Pattern = " "          ' Set pattern.
        oReg.Global = True          ' All matches
        txt = oReg.Replace(txt, "&nbsp;")
    End If
End Sub

'*** End